/**
 *                                  description
 *                                  -----------
 *  begin                : Sat Jul 8 2000
 *  copyright            : (C) 2000 by Simon White
 *  email                : s_a_white@email.com
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 * @author Ken Hndel
 *
 */
package sidplay.audio;

public abstract class AudioBase {

	protected AudioConfig _settings;
	protected String _errorString;
	protected byte[] _sampleBuffer;

	public AudioBase() {
		_errorString = "None";
		_sampleBuffer = null;
	}

	// All drivers must support these
	public abstract byte[] open(AudioConfig cfg, String name);

	public abstract byte[] write();

	public abstract void pause();

	public abstract void close();

	// Rev 1.3 (saw) - Definition is incorrect and has been updated.
	// On a reset hardware buffers may have changed and therefore a
	// new address needs to be returned by the driver.
	public abstract void reset();

	public String extension() {
		return "";
	}

	public byte[] buffer() {
		return _sampleBuffer;
	}

	public void getConfig(AudioConfig cfg) {
		cfg = _settings;
	}

	public final String getErrorString() {
		return _errorString;
	}
}
